#!/bin/bash

# Personal Expenses Setup Script

echo "Personal Expenses Setup"
echo "======================"
echo ""

# Check if running as root
if [ "$EUID" -eq 0 ]; then 
   echo "Please do not run as root"
   exit 1
fi

# Create upload directories
echo "Creating upload directories..."
mkdir -p uploads/expenses
mkdir -p uploads/prepaid_cards
chmod 755 uploads
chmod 755 uploads/expenses
chmod 755 uploads/prepaid_cards

# Create .htaccess for uploads protection
if [ ! -f "uploads/.htaccess" ]; then
    echo "Creating uploads/.htaccess..."
    cat > uploads/.htaccess << 'EOF'
# Protect uploads directory
<FilesMatch "\.(jpg|jpeg|png|gif|pdf|doc|docx|txt)$">
    <IfModule mod_authz_core.c>
        Require all granted
    </IfModule>
    <IfModule !mod_authz_core.c>
        Order allow,deny
        Allow from all
    </IfModule>
</FilesMatch>
EOF
fi

echo ""
echo "Setup complete!"
echo ""
echo "Next steps:"
echo "1. Create MySQL database and import schema.sql"
echo "2. Update config/config.php with your database credentials"
echo "3. Set up Google OAuth credentials in config/config.php"
echo "4. Update APP_URL in config/config.php"
echo ""
echo "See INSTALLATION.md for detailed instructions."

