-- Migration: Disaccoppiare show_in_dashboard dagli account
-- Crea tabella molti-a-molti tra utenti e account per gestire la visibilità dashboard per utente
-- Migra i dati esistenti e rimuove la colonna show_in_dashboard da accounts

-- Step 1: Creare la tabella user_account_dashboard
CREATE TABLE IF NOT EXISTS user_account_dashboard (
    user_id INT NOT NULL,
    account_id INT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (user_id, account_id),
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (account_id) REFERENCES accounts(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id),
    INDEX idx_account_id (account_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Step 2: Migrare i dati esistenti
-- Per ogni account con show_in_dashboard = TRUE, inserire nella nuova tabella per il suo owner
INSERT INTO user_account_dashboard (user_id, account_id)
SELECT user_id, id as account_id
FROM accounts
WHERE show_in_dashboard = TRUE
ON DUPLICATE KEY UPDATE user_id = user_id; -- Evita duplicati se esiste già

-- Step 3: Rimuovere la colonna show_in_dashboard dalla tabella accounts
ALTER TABLE accounts DROP COLUMN show_in_dashboard;
