-- Migration: Add Prepaid Card Sharing Functionality
-- This migration adds tables for prepaid card sharing between users
-- Prepaid cards can only be shared in write mode (always write-only)

-- Prepaid card shares table - stores active sharing relationships
CREATE TABLE IF NOT EXISTS prepaid_card_shares (
    id INT AUTO_INCREMENT PRIMARY KEY,
    prepaid_card_id INT NOT NULL,
    owner_user_id INT NOT NULL,
    shared_with_user_id INT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (prepaid_card_id) REFERENCES prepaid_cards(id) ON DELETE CASCADE,
    FOREIGN KEY (owner_user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (shared_with_user_id) REFERENCES users(id) ON DELETE CASCADE,
    UNIQUE KEY unique_prepaid_card_share (prepaid_card_id, shared_with_user_id),
    INDEX idx_prepaid_card_id (prepaid_card_id),
    INDEX idx_owner_user_id (owner_user_id),
    INDEX idx_shared_with_user_id (shared_with_user_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Prepaid card share invitations table - stores invitations for users not yet registered
CREATE TABLE IF NOT EXISTS prepaid_card_share_invitations (
    id INT AUTO_INCREMENT PRIMARY KEY,
    prepaid_card_id INT NOT NULL,
    owner_user_id INT NOT NULL,
    recipient_email VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (prepaid_card_id) REFERENCES prepaid_cards(id) ON DELETE CASCADE,
    FOREIGN KEY (owner_user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_prepaid_card_id (prepaid_card_id),
    INDEX idx_owner_user_id (owner_user_id),
    INDEX idx_recipient_email (recipient_email)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
