-- Migration: Add Fidelity Cards Functionality
-- This migration adds tables for fidelity cards management

-- Fidelity cards table
CREATE TABLE IF NOT EXISTS fidelity_cards (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    name VARCHAR(255) NOT NULL,
    store_name VARCHAR(255) NOT NULL,
    card_code VARCHAR(255) NOT NULL,
    description TEXT NULL,
    logo_path VARCHAR(500) NULL,
    card_image_path VARCHAR(500) NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_user_id (user_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Fidelity card shares table - stores active sharing relationships
CREATE TABLE IF NOT EXISTS fidelity_card_shares (
    id INT AUTO_INCREMENT PRIMARY KEY,
    fidelity_card_id INT NOT NULL,
    owner_user_id INT NOT NULL,
    shared_with_user_id INT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (fidelity_card_id) REFERENCES fidelity_cards(id) ON DELETE CASCADE,
    FOREIGN KEY (owner_user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (shared_with_user_id) REFERENCES users(id) ON DELETE CASCADE,
    UNIQUE KEY unique_fidelity_card_share (fidelity_card_id, shared_with_user_id),
    INDEX idx_fidelity_card_id (fidelity_card_id),
    INDEX idx_owner_user_id (owner_user_id),
    INDEX idx_shared_with_user_id (shared_with_user_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Fidelity card share invitations table - stores invitations for users not yet registered
CREATE TABLE IF NOT EXISTS fidelity_card_share_invitations (
    id INT AUTO_INCREMENT PRIMARY KEY,
    fidelity_card_id INT NOT NULL,
    owner_user_id INT NOT NULL,
    recipient_email VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (fidelity_card_id) REFERENCES fidelity_cards(id) ON DELETE CASCADE,
    FOREIGN KEY (owner_user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_fidelity_card_id (fidelity_card_id),
    INDEX idx_owner_user_id (owner_user_id),
    INDEX idx_recipient_email (recipient_email)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- User fidelity card order table - stores the display order for each user
CREATE TABLE IF NOT EXISTS user_fidelity_card_order (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    fidelity_card_id INT NOT NULL,
    display_order INT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (fidelity_card_id) REFERENCES fidelity_cards(id) ON DELETE CASCADE,
    UNIQUE KEY unique_user_fidelity_card_order (user_id, fidelity_card_id),
    INDEX idx_user_id (user_id),
    INDEX idx_fidelity_card_id (fidelity_card_id),
    INDEX idx_display_order (display_order)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- User fidelity card clicks table - tracks clicks for automatic ordering
CREATE TABLE IF NOT EXISTS user_fidelity_card_clicks (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    fidelity_card_id INT NOT NULL,
    click_count INT NOT NULL DEFAULT 0,
    last_clicked_at TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (fidelity_card_id) REFERENCES fidelity_cards(id) ON DELETE CASCADE,
    UNIQUE KEY unique_user_fidelity_card_clicks (user_id, fidelity_card_id),
    INDEX idx_user_id (user_id),
    INDEX idx_fidelity_card_id (fidelity_card_id),
    INDEX idx_click_count (click_count)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
