-- Migration: Add Prepaid Card Support to Expenses
-- This migration adds prepaid_card_id field to expenses table to allow expenses to be associated with prepaid cards

-- First, make account_id nullable (we'll add a constraint later to ensure at least one is set)
ALTER TABLE expenses 
MODIFY COLUMN account_id INT NULL;

-- Add prepaid_card_id column
ALTER TABLE expenses 
ADD COLUMN prepaid_card_id INT NULL AFTER account_id;

-- Add foreign key for prepaid_card_id
ALTER TABLE expenses 
ADD CONSTRAINT fk_expenses_prepaid_card 
FOREIGN KEY (prepaid_card_id) REFERENCES prepaid_cards(id) ON DELETE RESTRICT;

-- Add index for prepaid_card_id
ALTER TABLE expenses 
ADD INDEX idx_prepaid_card_id (prepaid_card_id);

-- Add check constraint to ensure at least one of account_id or prepaid_card_id is set
-- Note: MySQL doesn't support CHECK constraints in older versions, so we'll enforce this in application logic
-- For MySQL 8.0.16+, uncomment the following:
ALTER TABLE expenses 
ADD CONSTRAINT chk_expense_source CHECK (account_id IS NOT NULL OR prepaid_card_id IS NOT NULL);
