-- Migration: Add Account Sharing Functionality
-- This migration adds tables for account sharing between users

-- Account shares table - stores active sharing relationships
CREATE TABLE IF NOT EXISTS account_shares (
    id INT AUTO_INCREMENT PRIMARY KEY,
    account_id INT NOT NULL,
    owner_user_id INT NOT NULL,
    shared_with_user_id INT NOT NULL,
    sharing_mode ENUM('read-only', 'write') NOT NULL DEFAULT 'read-only',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (account_id) REFERENCES accounts(id) ON DELETE CASCADE,
    FOREIGN KEY (owner_user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (shared_with_user_id) REFERENCES users(id) ON DELETE CASCADE,
    UNIQUE KEY unique_account_share (account_id, shared_with_user_id),
    INDEX idx_account_id (account_id),
    INDEX idx_owner_user_id (owner_user_id),
    INDEX idx_shared_with_user_id (shared_with_user_id),
    INDEX idx_sharing_mode (sharing_mode)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Account share invitations table - stores invitations for users not yet registered
CREATE TABLE IF NOT EXISTS account_share_invitations (
    id INT AUTO_INCREMENT PRIMARY KEY,
    account_id INT NOT NULL,
    owner_user_id INT NOT NULL,
    recipient_email VARCHAR(255) NOT NULL,
    sharing_mode ENUM('read-only', 'write') NOT NULL DEFAULT 'read-only',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (account_id) REFERENCES accounts(id) ON DELETE CASCADE,
    FOREIGN KEY (owner_user_id) REFERENCES users(id) ON DELETE CASCADE,
    INDEX idx_account_id (account_id),
    INDEX idx_owner_user_id (owner_user_id),
    INDEX idx_recipient_email (recipient_email)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

