<?php
/**
 * Application Configuration
 */

// Google OAuth Configuration
// NOTE: Google OAuth does NOT allow private IP addresses (like 10.20.22.189) for redirect URIs
// For development, use one of these options:
// 1. localhost/127.0.0.1 (if accessing from the server itself)
// 2. ngrok tunnel URL (if accessing from other machines - see INSTALLATION.md)
define('GOOGLE_CLIENT_ID', '344635216050-vq1cm861dcmnk7r6s8snf695rr5quna6.apps.googleusercontent.com');
define('GOOGLE_CLIENT_SECRET', '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');
define('GOOGLE_REDIRECT_URI', 'https://personalexpenses.inimdns.biz/api/auth/google_callback.php');

// Application Settings
// For internal access, you can still use the private IP here
define('APP_URL', 'https://personalexpenses.inimdns.biz/');
define('UPLOAD_DIR', __DIR__ . '/../uploads/');
define('UPLOAD_URL', rtrim(APP_URL, '/') . '/uploads/');
define('MAX_UPLOAD_SIZE', 30 * 1024 * 1024); // 30MB

// Currency Exchange API (using exchangerate-api.com free tier)
define('EXCHANGE_RATE_API_URL', 'https://api.exchangerate-api.com/v4/latest/');

// Manifest token secret - used to generate secure tokens for manifest shortcuts
// This should be a random string - generate one with: openssl rand -hex 32
define('MANIFEST_TOKEN_SECRET', '1ae09870b8183651ab8960ddef623778fab42bdf18bda87f2d84d71f314461fa');

// Session Configuration
// IMPORTANT: All session settings must be set BEFORE session_start()
ini_set('session.use_only_cookies', 1);
// Session garbage collection: keep sessions for up to 8 days (691200 seconds)
// This ensures sessions are not garbage collected before the cookie expires
// Note: gc_maxlifetime should be longer than cookie lifetime to prevent premature cleanup
ini_set('session.gc_maxlifetime', 691200); // 8 days (longer than 7-day cookie)
// Increase probability of garbage collection (default is 1/100)
// This helps ensure old sessions are cleaned up regularly
ini_set('session.gc_probability', 1);
ini_set('session.gc_divisor', 100);

// Use database session handler instead of file-based sessions
// This makes sessions independent from PHP file-based sessions and system cleanup timers
try {
    require_once __DIR__ . '/../api/middleware/db_session_handler.php';
    $dbSessionHandler = new DatabaseSessionHandler();
    session_set_save_handler($dbSessionHandler, true);
    
    if (defined('SESSION_DEBUG_ENABLED') && SESSION_DEBUG_ENABLED) {
        error_log("Database session handler registered successfully");
    }
} catch (Exception $e) {
    error_log("ERROR: Failed to initialize database session handler: " . $e->getMessage());
    error_log("Please ensure:");
    error_log("1. Database connection is configured correctly");
    error_log("2. Table user_sessions exists (run: database/migration_add_user_sessions.sql)");
    // Fallback to file-based sessions if database handler fails
    // This allows the application to continue working even if migration hasn't been run
}

// Set cookie parameters with array format (PHP 7.3+)
// Cookie duration: 7 days (604800 seconds) - makes cookie persistent
$cookie_params = [
    'lifetime' => 604800, // 7 days
    'path' => '/',
    'domain' => '', // Empty means current domain
    'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on',
    'httponly' => true,
    'samesite' => 'Lax' // Prevents CSRF while allowing cookies to work
];
session_set_cookie_params($cookie_params);

// Track if this is a new session or existing one
$sessionName = session_name();
$cookieSessionId = $_COOKIE[$sessionName] ?? null;
$isNewSession = !isset($_COOKIE[$sessionName]);

session_start();

// Check what happened after session_start
$actualSessionId = session_id();
$sessionIdChanged = ($cookieSessionId && $actualSessionId !== $cookieSessionId);

// Log session start details if debug is enabled
if (defined('SESSION_DEBUG_ENABLED') && SESSION_DEBUG_ENABLED) {
    require_once __DIR__ . '/../api/middleware/auth.php';
    logSessionDebug('session_start_detailed', [
        'cookie_session_id' => $cookieSessionId ? substr($cookieSessionId, 0, 16) . '...' : null,
        'actual_session_id' => $actualSessionId ? substr($actualSessionId, 0, 16) . '...' : null,
        'session_id_changed' => $sessionIdChanged,
        'is_new_session' => $isNewSession,
        'session_handler' => 'database',
        'session_keys' => isset($_SESSION) ? array_keys($_SESSION) : [],
        'session_count' => isset($_SESSION) ? count($_SESSION) : 0,
        'diagnosis' => $sessionIdChanged ? 'Session ID changed - new session created instead of reading existing' : 
                      'Database session handler active'
    ]);
}

// Register shutdown function to log session state before script ends
if (defined('SESSION_DEBUG_ENABLED') && SESSION_DEBUG_ENABLED) {
    register_shutdown_function(function() {
        if (function_exists('logSessionDebug')) {
            $sessionSavePath = session_save_path();
            if (empty($sessionSavePath)) {
                $sessionSavePath = sys_get_temp_dir();
            }
            $sessionId = session_id();
            $sessionFilePath = $sessionSavePath . '/sess_' . $sessionId;
            $sessionFileExists = $sessionId && file_exists($sessionFilePath);
            $sessionFileSize = $sessionFileExists ? filesize($sessionFilePath) : 0;
            
            logSessionDebug('session_shutdown', [
                'session_id' => $sessionId ? substr($sessionId, 0, 16) . '...' : 'no-session',
                'has_user_id' => isset($_SESSION['user_id']),
                'session_keys' => isset($_SESSION) ? array_keys($_SESSION) : [],
                'session_count' => isset($_SESSION) ? count($_SESSION) : 0,
                'session_file_exists' => $sessionFileExists,
                'session_file_size' => $sessionFileSize,
                'script_name' => $_SERVER['SCRIPT_NAME'] ?? 'unknown'
            ]);
        }
    });
}

// Log new session creation if debug is enabled
if (defined('SESSION_DEBUG_ENABLED') && SESSION_DEBUG_ENABLED && $isNewSession) {
    require_once __DIR__ . '/../api/middleware/auth.php';
    logSessionDebug('session_started_new', [
        'session_id' => session_id(),
        'reason' => 'New session created (no cookie found)',
        'session_save_path' => session_save_path() ?: sys_get_temp_dir()
    ]);
}

// Error Reporting (disable in production)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Timezone
date_default_timezone_set('Europe/Rome');

// Session Debug Configuration
// Set to true to enable detailed session debugging
// Debug logs will be written to logs/session_debug.log
define('SESSION_DEBUG_ENABLED', false); // Change to true to enable debug logging
define('SESSION_DEBUG_LOG_FILE', __DIR__ . '/../logs/session_debug.log');

