<?php
/**
 * Fidelity Card Click Tracking API
 * Tracks clicks on fidelity cards for automatic ordering
 */

ob_start();
ini_set('display_errors', 0);
error_reporting(E_ALL);

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../middleware/auth.php';

ini_set('display_errors', 0);
ob_clean();

header('Content-Type: application/json');

try {
    $user_id = requireAuth();
    $db = new Database();
    $conn = $db->getConnection();

    $method = $_SERVER['REQUEST_METHOD'];
    $card_id = isset($_GET['id']) ? intval($_GET['id']) : null;

    switch ($method) {
    case 'POST':
        // Track a click on a fidelity card
        if (!$card_id) {
            http_response_code(400);
            echo json_encode(['error' => 'Card ID is required']);
            break;
        }
        
        // Verify user has access to the card (owned or shared)
        $stmt = $conn->prepare("
            SELECT fc.id
            FROM fidelity_cards fc
            WHERE fc.id = :card_id
            AND (
                fc.user_id = :user_id
                OR EXISTS (
                    SELECT 1 FROM fidelity_card_shares fcs 
                    WHERE fcs.fidelity_card_id = fc.id 
                    AND fcs.shared_with_user_id = :user_id2
                )
            )
        ");
        $stmt->execute([':card_id' => $card_id, ':user_id' => $user_id, ':user_id2' => $user_id]);
        if (!$stmt->fetch()) {
            http_response_code(404);
            echo json_encode(['error' => 'Card not found or access denied']);
            break;
        }
        
        // Insert or update click count
        $stmt = $conn->prepare("
            INSERT INTO user_fidelity_card_clicks (user_id, fidelity_card_id, click_count, last_clicked_at)
            VALUES (:user_id, :fidelity_card_id, 1, NOW())
            ON DUPLICATE KEY UPDATE 
                click_count = click_count + 1,
                last_clicked_at = NOW()
        ");
        
        $stmt->execute([
            ':user_id' => $user_id,
            ':fidelity_card_id' => $card_id
        ]);
        
        echo json_encode(['success' => true]);
        break;
        
    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Error tracking click: ' . $e->getMessage()]);
    error_log('Fidelity card click API error: ' . $e->getMessage());
}
