<?php
/**
 * Logout Handler
 */

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../middleware/auth.php';

header('Content-Type: application/json');

$userId = $_SESSION['user_id'] ?? null;
$sessionId = session_id();

logSessionDebug('logout_called', [
    'user_id' => $userId,
    'session_id' => $sessionId ?: 'no-session-id'
]);

session_destroy();

logSessionDebug('session_destroyed_logout', [
    'reason' => 'User logout',
    'user_id' => $userId
]);

echo json_encode(['success' => true, 'message' => 'Logged out successfully']);
exit;

