package com.personalexpenses.app;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class PrepaidCardsFragment extends Fragment {
    private RecyclerView recyclerView;
    private PrepaidCardAdapter adapter;
    private List<PrepaidCard> cards = new ArrayList<>();
    private ApiClient apiClient;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_prepaid_cards, container, false);
        
        recyclerView = view.findViewById(R.id.prepaid_cards_recycler);
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext()));
        
        MainActivity activity = (MainActivity) getActivity();
        if (activity != null) {
            apiClient = new ApiClient(getContext(), activity.getApiBaseUrl());
        }
        
        adapter = new PrepaidCardAdapter(cards, card -> {
            // Open barcode view
            if (card.getCardNumber() != null && !card.getCardNumber().isEmpty()) {
                Intent intent = new Intent(getContext(), PrepaidCardBarcodeActivity.class);
                intent.putExtra(PrepaidCardBarcodeActivity.EXTRA_CARD_NUMBER, card.getCardNumber());
                intent.putExtra(PrepaidCardBarcodeActivity.EXTRA_CARD_NAME, card.getName());
                startActivity(intent);
            } else {
                Toast.makeText(getContext(), "Numero carta non disponibile", Toast.LENGTH_SHORT).show();
            }
        });
        
        recyclerView.setAdapter(adapter);
        
        loadPrepaidCards();
        
        return view;
    }

    private void loadPrepaidCards() {
        apiClient.get("/prepaid_cards/index.php", new ApiClient.ApiCallback() {
            @Override
            public void onSuccess(String response) {
                Gson gson = new Gson();
                Type listType = new TypeToken<List<PrepaidCard>>(){}.getType();
                List<PrepaidCard> loadedCards = gson.fromJson(response, listType);
                
                getActivity().runOnUiThread(() -> {
                    cards.clear();
                    cards.addAll(loadedCards);
                    adapter.notifyDataSetChanged();
                });
            }

            @Override
            public void onError(String error) {
                getActivity().runOnUiThread(() -> {
                    Toast.makeText(getContext(), "Errore: " + error, Toast.LENGTH_SHORT).show();
                });
            }
        });
    }

    public static class PrepaidCard {
        private int id;
        private String name;
        private String cardNumber;
        private String baseCurrency;
        private String openingDate;
        private String expireDate;
        private String photoPath;

        // Getters and setters
        public int getId() { return id; }
        public void setId(int id) { this.id = id; }
        public String getName() { return name; }
        public void setName(String name) { this.name = name; }
        public String getCardNumber() { return cardNumber; }
        public void setCardNumber(String cardNumber) { this.cardNumber = cardNumber; }
        public String getBaseCurrency() { return baseCurrency; }
        public void setBaseCurrency(String baseCurrency) { this.baseCurrency = baseCurrency; }
        public String getOpeningDate() { return openingDate; }
        public void setOpeningDate(String openingDate) { this.openingDate = openingDate; }
        public String getExpireDate() { return expireDate; }
        public void setExpireDate(String expireDate) { this.expireDate = expireDate; }
        public String getPhotoPath() { return photoPath; }
        public void setPhotoPath(String photoPath) { this.photoPath = photoPath; }
    }
}

