# Installation Guide

## Prerequisites

- LAMP server (Linux, Apache, MySQL, PHP 7.4+)
- PHP extensions: PDO, PDO_MySQL, curl, gd (for image handling)
- Google Cloud Platform account (for OAuth)
- Android Studio (for Android app development)

## Step 1: Database Setup

1. Create MySQL database:
```bash
mysql -u root -p
CREATE DATABASE personal_expenses CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
EXIT;
```

2. Import schema:
```bash
mysql -u root -p personal_expenses < database/schema.sql
```

3. Create database user (optional but recommended):
```sql
CREATE USER 'expenses_user'@'localhost' IDENTIFIED BY 'sdDHwa34-dr(g';
GRANT ALL PRIVILEGES ON personal_expenses.* TO 'expenses_user'@'localhost';
FLUSH PRIVILEGES;
```

4. Update `config/database.php` with your database credentials.

## Step 2: Google OAuth Setup

**IMPORTANT:** Google OAuth does NOT allow private IP addresses (like `10.20.22.189`) for redirect URIs. You must use one of the following options for development:

### Option A: Using localhost (Recommended for local development)

If you're accessing the application from the server itself:

1. Go to [Google Cloud Console](https://console.cloud.google.com/)
2. Create a new project or select an existing one
3. Enable Google+ API:
   - Navigate to "APIs & Services" > "Library"
   - Search for "Google+ API" and enable it
4. Create OAuth 2.0 credentials:
   - Go to "APIs & Services" > "Credentials"
   - Click "Create Credentials" > "OAuth client ID"
   - Choose "Web application"
   - Add authorized redirect URI: `http://localhost//api/auth/google_callback.php`
   - Also add: `http://127.0.0.1//api/auth/google_callback.php` (optional)
   - Copy Client ID and Client Secret
5. Update `config/config.php`:
   - Replace `YOUR_GOOGLE_CLIENT_ID` with your Client ID
   - Replace `YOUR_GOOGLE_CLIENT_SECRET` with your Client Secret
   - Set `GOOGLE_REDIRECT_URI` to `http://localhost//api/auth/google_callback.php`
   - Set `APP_URL` to `http://10.20.22.189/` (for internal access)

### Option B: Using ngrok (For accessing from other machines)

If you need to access the application from other machines on your network:

1. Install ngrok:
   ```bash
   # Download from https://ngrok.com/download or install via package manager
   # For Ubuntu/Debian:
   curl -s https://ngrok-agent.s3.amazonaws.com/ngrok.asc | sudo tee /etc/apt/trusted.gpg.d/ngrok.asc >/dev/null
   echo "deb https://ngrok-agent.s3.amazonaws.com buster main" | sudo tee /etc/apt/sources.list.d/ngrok.list
   sudo apt update && sudo apt install ngrok
   ```

2. Sign up for a free ngrok account at https://ngrok.com/ and get your authtoken

3. Configure ngrok:
   ```bash
   ngrok config add-authtoken YOUR_AUTH_TOKEN
   ```

4. Start ngrok tunnel:
   ```bash
   ngrok http 80 --host-header="10.20.22.189"
   ```
   Note: ngrok will provide a public URL like `https://abc123.ngrok-free.app`

5. In Google Cloud Console:
   - Add authorized redirect URI: `https://YOUR_NGROK_URL.ngrok-free.app//api/auth/google_callback.php`
   - Replace `YOUR_NGROK_URL` with your actual ngrok URL

6. Update `config/config.php`:
   - Set `GOOGLE_REDIRECT_URI` to `https://YOUR_NGROK_URL.ngrok-free.app//api/auth/google_callback.php`
   - Set `APP_URL` to `https://YOUR_NGROK_URL.ngrok-free.app/`

**Note:** The ngrok URL changes each time you restart ngrok (unless you have a paid plan with a static domain). You'll need to update both Google Cloud Console and `config/config.php` if the URL changes.

## Step 3: File Permissions

1. Create upload directories:
```bash
mkdir -p uploads/expenses
mkdir -p uploads/prepaid_cards
chmod 755 uploads
chmod 755 uploads/expenses
chmod 755 uploads/prepaid_cards
```

2. Ensure Apache can write to uploads:
```bash
chown -R www-data:www-data uploads
```

## Step 4: Apache Configuration

1. Ensure mod_rewrite is enabled:
```bash
sudo a2enmod rewrite
sudo systemctl restart apache2
```

2. Configure virtual host (if needed):
```apache
<VirtualHost *:80>
    ServerName your-domain.com
    DocumentRoot /path/to/
    
    <Directory /path/to/>
        Options -Indexes +FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

## Step 5: PHP Configuration

1. Install required PHP extensions:
```bash
# For Ubuntu/Debian:
sudo apt update
sudo apt install php-curl php-gd php-mysql php-xml php-zip

# For CentOS/RHEL:
sudo yum install php-curl php-gd php-mysql php-xml php-zip

# For Fedora:
sudo dnf install php-curl php-gd php-mysql php-xml php-zip
```

2. Restart Apache to load the extensions:
```bash
sudo systemctl restart apache2  # Ubuntu/Debian
# or
sudo systemctl restart httpd     # CentOS/RHEL/Fedora
```

3. Verify extensions are installed:
```bash
php -m | grep -E "curl|gd|pdo_mysql"
```

4. Ensure PHP has sufficient limits in `php.ini`:
```ini
upload_max_filesize = 30M
post_max_size = 30M
memory_limit = 128M
```

## Step 6: Android App Setup

1. Open Android Studio
2. Import the `android` folder
3. Update `MainActivity.java`:
   - Change `apiBaseUrl` to your server URL (e.g., `http://192.168.1.100//api`)
4. Update `AndroidManifest.xml` if needed:
   - Ensure `android:usesCleartextTraffic="true"` is set for HTTP development
5. Build and run

## Step 7: Testing

1. Access the web application: `http://10.20.22.189/`
2. Click "Accedi con Google" and complete OAuth flow
3. Create an account
4. Add some expenses and test functionality

## Production Setup (HTTPS with nginx)

When ready for production:

1. Install nginx and certbot:
```bash
sudo apt install nginx certbot python3-certbot-nginx
```

2. Configure nginx reverse proxy:
```nginx
server {
    listen 80;
    server_name your-domain.com;
    
    location / {
        proxy_pass http://localhost:8080;
        proxy_set_header Host $host;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
    }
}
```

3. Obtain SSL certificate:
```bash
sudo certbot --nginx -d your-domain.com
```

4. Update `config/config.php`:
   - Change `APP_URL` to `https://your-domain.com/`
   - Change `GOOGLE_REDIRECT_URI` to use HTTPS

5. Update Android app:
   - Change `apiBaseUrl` to HTTPS URL
   - Remove `android:usesCleartextTraffic="true"` from AndroidManifest.xml

## Troubleshooting

### Database Connection Issues
- Verify MySQL is running: `sudo systemctl status mysql`
- Check database credentials in `config/database.php`
- Ensure database user has proper permissions

### Google OAuth Issues

**Error: "device_id and device_name are required for private IP"**
- This error occurs when using a private IP address (like `10.20.22.189`) as a redirect URI
- **Solution:** Use `localhost` or `127.0.0.1` instead, or set up ngrok (see Step 2, Option B)
- Update the redirect URI in both Google Cloud Console and `config/config.php`

**Other OAuth Issues:**
- Verify redirect URI matches exactly in Google Cloud Console (including http/https and trailing slashes)
- Check that Google+ API is enabled
- Verify Client ID and Secret are correct
- Ensure the redirect URI in `config/config.php` matches exactly what's configured in Google Cloud Console
- For ngrok: Remember to update the redirect URI if your ngrok URL changes

**Error: "Call to undefined function curl_init()"**
- This error occurs when the PHP curl extension is not installed
- **Solution:** Install php-curl extension (see Step 5) and restart Apache:
  ```bash
  sudo apt install php-curl  # Ubuntu/Debian
  sudo yum install php-curl  # CentOS/RHEL
  sudo dnf install php-curl  # Fedora
  sudo systemctl restart apache2  # or httpd
  ```
- Verify installation: `php -m | grep curl`

### File Upload Issues
- Check directory permissions: `ls -la uploads/`
- Verify PHP upload limits: `php -i | grep upload_max_filesize`
- Check Apache error logs: `tail -f /var/log/apache2/error.log`

### Session Issues
- Ensure PHP sessions directory is writable
- Check `session.save_path` in `php.ini`
- Verify cookies are enabled in browser

## Security Notes

- Change default database password
- Use strong passwords for database users
- Enable HTTPS in production
- Regularly update PHP and MySQL
- Review file upload security
- Implement rate limiting for API endpoints
- Add CSRF protection for forms

