<?php
/**
 * Migration script: Create "No Account" for existing users who don't have it
 * Run this script once to add "No Account" to all existing users
 */

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../config/database.php';

$db = new Database();
$conn = $db->getConnection();

// Get the "OTHER" account type ID
$stmt = $conn->prepare("SELECT id FROM account_types WHERE code = 'OTHER'");
$stmt->execute();
$account_type = $stmt->fetch();

if (!$account_type) {
    die("Error: Account type 'OTHER' not found in database.\n");
}

$account_type_id = $account_type['id'];

// Get all users
$stmt = $conn->prepare("SELECT id, default_currency FROM users");
$stmt->execute();
$users = $stmt->fetchAll();

$created_count = 0;
$skipped_count = 0;

foreach ($users as $user) {
    // Check if user already has "No Account"
    $stmt = $conn->prepare("SELECT id FROM accounts WHERE user_id = :user_id AND name = 'No Account'");
    $stmt->execute([':user_id' => $user['id']]);
    $existing = $stmt->fetch();
    
    if ($existing) {
        $skipped_count++;
        continue;
    }
    
    // Create "No Account" for this user
    $default_currency = $user['default_currency'] ?? 'EUR';
    
    $stmt = $conn->prepare("
        INSERT INTO accounts (user_id, name, type_id, base_currency, opening_date)
        VALUES (:user_id, 'No Account', :type_id, :base_currency, CURDATE())
    ");
    
    try {
        $stmt->execute([
            ':user_id' => $user['id'],
            ':type_id' => $account_type_id,
            ':base_currency' => $default_currency
        ]);
        $created_count++;
        echo "Created 'No Account' for user ID {$user['id']}\n";
    } catch (Exception $e) {
        echo "Error creating 'No Account' for user ID {$user['id']}: " . $e->getMessage() . "\n";
    }
}

echo "\nMigration completed:\n";
echo "- Created: $created_count\n";
echo "- Skipped (already exists): $skipped_count\n";

