<?php
/**
 * Exchange Rate API
 */

require_once __DIR__ . '/../../config/config.php';

header('Content-Type: application/json');

$from = $_GET['from'] ?? null;
$to = $_GET['to'] ?? null;

if (!$from || !$to) {
    http_response_code(400);
    echo json_encode(['error' => 'From and to currencies required']);
    exit;
}

try {
    $url = EXCHANGE_RATE_API_URL . $from;
    $response = file_get_contents($url);
    $data = json_decode($response, true);
    
    if (isset($data['rates'][$to])) {
        echo json_encode([
            'from' => $from,
            'to' => $to,
            'rate' => floatval($data['rates'][$to]),
            'date' => $data['date'] ?? date('Y-m-d')
        ]);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Exchange rate not found']);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Failed to fetch exchange rate']);
}

