<?php
/**
 * Securities Summary API
 */

require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../middleware/auth.php';

header('Content-Type: application/json');

$user_id = requireAuth();
$db = new Database();
$conn = $db->getConnection();

$account_id = $_GET['account_id'] ?? null;

if ($account_id) {
    // Verify account belongs to user
    $stmt = $conn->prepare("SELECT id FROM accounts WHERE id = :account_id AND user_id = :user_id");
    $stmt->execute([':account_id' => $account_id, ':user_id' => $user_id]);
    if (!$stmt->fetch()) {
        http_response_code(404);
        echo json_encode(['error' => 'Account not found']);
        exit;
    }
    
    $stmt = $conn->prepare("
        SELECT 
            symbol,
            SUM(CASE WHEN transaction_type = 'PURCHASE' THEN quantity ELSE -quantity END) as total_quantity,
            SUM(CASE WHEN transaction_type = 'PURCHASE' THEN purchase_price ELSE 0 END) / 
            NULLIF(SUM(CASE WHEN transaction_type = 'PURCHASE' THEN quantity ELSE 0 END), 0) as mean_purchase_price,
            SUM(CASE WHEN transaction_type = 'PURCHASE' THEN purchase_price ELSE -purchase_price END) as total_value,
            currency,
            COUNT(*) as transactions
        FROM securities
        WHERE account_id = :account_id
        GROUP BY symbol, currency
        HAVING total_quantity > 0
        ORDER BY symbol
    ");
    $stmt->execute([':account_id' => $account_id]);
} else {
    // Get summary for all securities accounts
    $stmt = $conn->prepare("
        SELECT 
            s.symbol,
            a.id as account_id,
            a.name as account_name,
            SUM(CASE WHEN s.transaction_type = 'PURCHASE' THEN s.quantity ELSE -s.quantity END) as total_quantity,
            SUM(CASE WHEN s.transaction_type = 'PURCHASE' THEN s.purchase_price ELSE 0 END) / 
            NULLIF(SUM(CASE WHEN s.transaction_type = 'PURCHASE' THEN s.quantity ELSE 0 END), 0) as mean_purchase_price,
            SUM(CASE WHEN s.transaction_type = 'PURCHASE' THEN s.purchase_price ELSE -s.purchase_price END) as total_value,
            s.currency,
            COUNT(*) as transactions
        FROM securities s
        JOIN accounts a ON s.account_id = a.id
        WHERE a.user_id = :user_id
        GROUP BY s.symbol, a.id, s.currency
        HAVING total_quantity > 0
        ORDER BY a.name, s.symbol
    ");
    $stmt->execute([':user_id' => $user_id]);
}

$summary = $stmt->fetchAll();

echo json_encode($summary);

