<?php
/**
 * Notifications Helper Functions
 * Utility functions for creating notifications
 */

/**
 * Create a notification for a user
 * 
 * @param PDO $conn Database connection
 * @param int $user_id User ID to notify
 * @param string $type Notification type ('share_created', 'share_updated', 'share_removed', 'card_expiring')
 * @param string $title Notification title
 * @param string $message Notification message
 * @param string|null $related_entity_type Entity type ('prepaid_card', 'account', 'fidelity_card')
 * @param int|null $related_entity_id Entity ID
 * @return bool Success status
 */
function createNotification($conn, $user_id, $type, $title, $message, $related_entity_type = null, $related_entity_id = null) {
    try {
        $stmt = $conn->prepare("
            INSERT INTO notifications (user_id, type, title, message, related_entity_type, related_entity_id)
            VALUES (:user_id, :type, :title, :message, :related_entity_type, :related_entity_id)
        ");
        
        return $stmt->execute([
            ':user_id' => $user_id,
            ':type' => $type,
            ':title' => $title,
            ':message' => $message,
            ':related_entity_type' => $related_entity_type,
            ':related_entity_id' => $related_entity_id
        ]);
    } catch (Exception $e) {
        error_log("Error creating notification: " . $e->getMessage());
        return false;
    }
}
