package com.personalexpenses.app;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;

import java.util.HashMap;
import java.util.Map;

public class PrepaidCardBarcodeActivity extends AppCompatActivity {
    public static final String EXTRA_CARD_NUMBER = "card_number";
    public static final String EXTRA_CARD_NAME = "card_name";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_prepaid_card_barcode);

        String cardNumber = getIntent().getStringExtra(EXTRA_CARD_NUMBER);
        String cardName = getIntent().getStringExtra(EXTRA_CARD_NAME);

        TextView cardNameView = findViewById(R.id.card_name);
        ImageView barcodeView = findViewById(R.id.barcode_image);

        if (cardName != null) {
            cardNameView.setText(cardName);
        }

        if (cardNumber != null && !cardNumber.isEmpty()) {
            // Generate barcode
            Bitmap barcode = generateBarcode(cardNumber);
            if (barcode != null) {
                barcodeView.setImageBitmap(barcode);
            }
        }
    }

    private Bitmap generateBarcode(String data) {
        try {
            Map<EncodeHintType, Object> hints = new HashMap<>();
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hints.put(EncodeHintType.MARGIN, 1);

            QRCodeWriter writer = new QRCodeWriter();
            BitMatrix bitMatrix = writer.encode(data, BarcodeFormat.QR_CODE, 512, 512, hints);

            int width = bitMatrix.getWidth();
            int height = bitMatrix.getHeight();
            Bitmap bitmap = Bitmap.createBitmap(width, height, Bitmap.Config.RGB_565);

            for (int x = 0; x < width; x++) {
                for (int y = 0; y < height; y++) {
                    bitmap.setPixel(x, y, bitMatrix.get(x, y) ? 0xFF000000 : 0xFFFFFFFF);
                }
            }

            return bitmap;
        } catch (WriterException e) {
            e.printStackTrace();
            return null;
        }
    }
}

