package com.personalexpenses.app;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.List;

public class PrepaidCardAdapter extends RecyclerView.Adapter<PrepaidCardAdapter.ViewHolder> {
    private List<PrepaidCardsFragment.PrepaidCard> cards;
    private OnCardClickListener listener;

    public interface OnCardClickListener {
        void onCardClick(PrepaidCardsFragment.PrepaidCard card);
    }

    public PrepaidCardAdapter(List<PrepaidCardsFragment.PrepaidCard> cards, OnCardClickListener listener) {
        this.cards = cards;
        this.listener = listener;
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext())
                .inflate(android.R.layout.simple_list_item_2, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        PrepaidCardsFragment.PrepaidCard card = cards.get(position);
        holder.nameText.setText(card.getName());
        holder.detailsText.setText(card.getCardNumber() != null ? card.getCardNumber() : "Nessun numero");
        
        holder.itemView.setOnClickListener(v -> {
            if (listener != null) {
                listener.onCardClick(card);
            }
        });
    }

    @Override
    public int getItemCount() {
        return cards.size();
    }

    static class ViewHolder extends RecyclerView.ViewHolder {
        TextView nameText;
        TextView detailsText;

        ViewHolder(View view) {
            super(view);
            nameText = view.findViewById(android.R.id.text1);
            detailsText = view.findViewById(android.R.id.text2);
        }
    }
}

