# Personal Expenses Application

A comprehensive web and Android application for managing personal expenses with multiple accounts, tax deductions, securities tracking, and prepaid cards.

## Features

### User Management
- Google OAuth authentication
- User profile with default currency and account settings

### Account Management
- Multiple account types:
  - Bank Current Account
  - Deposit Account
  - Securities Account
  - Other (with tax specification)
- Each account has:
  - Base currency
  - Opening date
  - ID number
  - Optional expire/closure date
  - Tax type (for "Other" accounts)

### Fund Transfers
- Transfer funds between accounts
- Automatic currency conversion with exchange rate fetching
- Manual exchange rate override

### Securities Management
- Track securities within securities accounts
- Symbol, quantity, purchase price tracking
- Summary views showing totals by symbol

### Expense Tracking
- Add expenses with date, description, account
- Tax-deductible expense marking
- Italian tax deduction categories:
  - Asilo
  - Assicurazione vita
  - Donazione
  - Risparmio energetico
  - Giardino
  - Altri redditi
  - Ristrutturazione edilizia
  - Sanita
  - Sicurezza
  - Tasse
- Multiple attachments per expense (photos, documents, links)

### Prepaid Cards
- Manage prepaid cards similar to accounts
- Optional photo attachment
- Barcode display in Android app for easy vendor use

## Installation

### Database Setup

1. Create MySQL database:
```sql
CREATE DATABASE personal_expenses CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

2. Import schema:
```bash
mysql -u root -p personal_expenses < database/schema.sql
```

### Backend Configuration

1. Update `config/config.php`:
   - Set your Google OAuth Client ID and Secret
   - Update database credentials in `config/database.php`
   - Set `APP_URL` to your server URL
   - Configure upload directory permissions

2. Create upload directories:
```bash
mkdir -p uploads/expenses
mkdir -p uploads/prepaid_cards
chmod 755 uploads
```

### Google OAuth Setup

1. Go to [Google Cloud Console](https://console.cloud.google.com/)
2. Create a new project or select existing
3. Enable Google+ API
4. Create OAuth 2.0 credentials
5. Add authorized redirect URI: `http://your-domain/api/auth/google_callback.php`
6. Update `GOOGLE_CLIENT_ID` and `GOOGLE_CLIENT_SECRET` in `config/config.php`

### Web Application

The web application is ready to use. Simply point your web server to the project root directory.

### Android Application

1. Open Android Studio
2. Import the `android` folder
3. Update `apiBaseUrl` in `MainActivity.java` with your server IP/domain
4. Build and run

## Project Structure

```
personalExpenses/
├── api/                    # PHP API endpoints
│   ├── auth/              # Authentication
│   ├── users/             # User management
│   ├── accounts/          # Account management
│   ├── expenses/          # Expense tracking
│   ├── transfers/         # Fund transfers
│   ├── securities/        # Securities management
│   └── prepaid_cards/     # Prepaid cards
├── assets/                # Frontend assets
│   ├── css/
│   └── js/
├── config/                # Configuration files
├── database/              # Database schema
├── uploads/               # File uploads
├── android/               # Android application
└── index.html             # Main web interface
```

## API Endpoints

### Authentication
- `GET /api/auth/google_login.php` - Initiate Google login
- `GET /api/auth/google_callback.php` - OAuth callback
- `GET /api/auth/check_session.php` - Check session
- `GET /api/auth/logout.php` - Logout

### Accounts
- `GET /api/accounts/index.php` - List accounts
- `POST /api/accounts/index.php` - Create account
- `GET /api/accounts/types.php` - Get account types
- `GET /api/accounts/balance.php?account_id=X` - Get account balance
- `GET /api/accounts/totals.php` - Get all account totals

### Expenses
- `GET /api/expenses/index.php` - List expenses
- `POST /api/expenses/index.php` - Create expense
- `GET /api/expenses/tax_categories.php` - Get tax categories
- `POST /api/expenses/attachments.php` - Add attachment
- `DELETE /api/expenses/attachments.php?id=X` - Delete attachment

### Transfers
- `GET /api/transfers/index.php` - List transfers
- `POST /api/transfers/index.php` - Create transfer
- `GET /api/transfers/exchange_rate.php?from=X&to=Y` - Get exchange rate

### Securities
- `GET /api/securities/index.php` - List securities
- `POST /api/securities/index.php` - Create security
- `GET /api/securities/summary.php` - Get securities summary

### Prepaid Cards
- `GET /api/prepaid_cards/index.php` - List prepaid cards
- `POST /api/prepaid_cards/index.php` - Create prepaid card

## Development Notes

- The application uses HTTP during development. For production, set up nginx reverse proxy with HTTPS and Let's Encrypt certificates.
- Exchange rates are fetched from exchangerate-api.com free tier
- File uploads are stored in the `uploads/` directory
- Android app uses ZXing library for barcode generation

## License

This project is provided as-is for personal use.

