# Fix Session Permissions Issue

## Problema Identificato

La directory `/var/lib/php/sessions` ha permessi `drwx-wx-wt` che significa:
- Owner (root): può leggere, scrivere, eseguire ✓
- Group: può scrivere ed eseguire ma **NON può leggere** ✗
- Others: può scrivere ed eseguire ma **NON può leggere** ✗

Questo causa il problema perché PHP (che gira come `www-data`) può creare file nella directory, ma quando cerca di leggere i file di sessione esistenti, potrebbe avere problemi.

## Soluzione

Eseguire questi comandi sul server per correggere i permessi:

```bash
# Correggere i permessi della directory delle sessioni
sudo chmod 1733 /var/lib/php/sessions
# oppure (più permissivo ma più sicuro per PHP)
sudo chmod 1737 /var/lib/php/sessions
```

**Spiegazione dei permessi:**
- `1733` = `drwx-wx-wt` (come ora, ma con lettura per tutti)
- `1737` = `drwxrwxrwt` (lettura, scrittura, esecuzione per tutti, sticky bit)

**Alternativa più sicura (consigliata):**
```bash
# Impostare il gruppo della directory a www-data
sudo chgrp www-data /var/lib/php/sessions
# Dare permessi di lettura/scrittura/esecuzione al gruppo
sudo chmod 1770 /var/lib/php/sessions
```

Questo darà:
- Owner (root): rwx
- Group (www-data): rwx
- Others: nessun accesso
- Sticky bit: attivo (previene cancellazione accidentale)

## Verifica

Dopo aver corretto i permessi, verificare:

```bash
ls -ld /var/lib/php/sessions
```

Dovrebbe mostrare qualcosa come:
```
drwxrwxrwt 2 root www-data 4096 Jan 16 08:39 /var/lib/php/sessions
```

Poi testare che PHP possa leggere e scrivere:

```bash
sudo -u www-data touch /var/lib/php/sessions/test_file
sudo -u www-data cat /var/lib/php/sessions/test_file
sudo rm /var/lib/php/sessions/test_file
```

Se entrambi i comandi funzionano senza errori, i permessi sono corretti.

## Note

- Il problema è che PHP può creare file ma non leggerli correttamente a causa dei permessi della directory
- Questo causa file di sessione vuoti (0 bytes) perché PHP non può verificare/aggiornare i file esistenti
- Dopo aver corretto i permessi, le sessioni dovrebbero funzionare correttamente
